// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : EntitySubShot.cpp
// Date           : February 2008
//
// Description    : Refer to description in corresponding header.
//
// ///////////////////////////////////////////////////////////////////////////


#include "EntitySubShot.h"
#include "Level.h"
#include "Application.h"




EntitySubShot::EntitySubShot()
{

  SetFrame( Dobbs::ANIM_SUB_SHOT );
  SetRect( &m_CollisionRect, 0, 0, 47, 31 );
  m_Floating            = true;
  m_DiesIfOutsideScreen = true;
  m_CanSleep            = false;

}



EntitySubShot::~EntitySubShot() 
{
}



void EntitySubShot::OnEvent( const EntityEvent Event, int Param1, int Param2, const std::string& TextParam, Entity* pEntity )
{

  switch ( Event )
  {
    case EE_BLOCKED_LEFT:
    case EE_BLOCKED_RIGHT:
    case EE_BLOCKED_TOP:
    case EE_BLOCKED_BOTTOM:
      g_App.PlaySound( "Laser.Explode" );
      Die();
      break;
    case EE_INIT:
      if ( m_Direction == Dobbs::DIR_LEFT )
      {
        SetVelX( -400.0f );
      }
      else if ( m_Direction == Dobbs::DIR_RIGHT )
      {
        SetVelX( 400.0f );
      }
      break;
    case EE_DIE:
      m_pLevel->SpawnEntity( Dobbs::ENTITY_TYPE_EXPLOSION, 0, GetX() + 16, GetY() + 16 );
      break;
  }
  Entity::OnEvent( Event, Param1, Param2, TextParam, pEntity );

}



